# Openllet Temporal Query

This repository contains Openllet Temporal Query and the benchmarks which it was examined against.
This document guides you through the installation and execution process for reproducing all results.

The results that were obtained on our benchmarking computer are also already included in this repository, including the raw outputs of our tools.
You can find these files in `results`.

For more information on our implementation in `openllet`, please refer to [`openllet/README.md`](openllet/README.md) and [`openllet/module-tcq/README.md`](openllet/module-tcq/README.md).
For more information on our benchmarks, please refer to [`tobm/README.md`](tobm/README.md).

## Overview

The following folders are located in this directory:

- `tobm` contains the Temporal Ontology Benchmark
- `openllet` contains the Openllet Temporal Query reasoner
- `lydia` contains the Lydia dependency
- `mltl2ltlf` contains the MLTL2LTLf dependency
- `config` contains the Openllet configuration files
- `generate_benchmarks.sh` deterministically creates the set of benchmarks using `tobm` into the `benchmarks/aboxes` folder
- `execute_benchmarks.sh` executes `openllet temporal-query` on alls benchmarks in `benchmarks` and stores the relevant memory and wallclock time information in `results`

# Run benchmarks

To run the benchmarks, we first install all dependencies and then Openllet Temporal Query.

## Installation (to execute Openllet Temporal Query)

The installation is tested on UNIX-systems.
This installation assumes a Ubuntu system with `bash`, however, it will work analogously on other Linux distributions or shells.
It has been successfully tested on the TACAS 23 Virtual Machine.

### Prerequisites

We require the following software to be installed on your system:

- Java version >= 17 (you can check your version with `java -version`)
- Maven (fitting to the Java version, you can check your version with `mvn -version`)
- Python 3 with PIP
- Docker (optional, if Lydia shall not be compiled from source)

To install Python, PIP, Java, and Maven, call `sudo apt-get update && sudo apt-get install python3 python3-pip openjdk-17-jdk maven`.

For the optional Docker dependency, follow the [official instructions](https://docs.docker.com/engine/install/ubuntu/#install-using-the-repository) to install Docker.
After installation, you need to start the Docker daemon using `sudo systemctl start docker`.
Later, we will use `docker run` without root rights, therefore, please add your user to the `docker` group as per the [documentation](https://docs.docker.com/engine/install/linux-postinstall).
You may need to restart the TACAS 23 Virtual Machine.

### Step-by-step instructions

#### Installing MLTL2LTLf

1. Navigate to the `mltl2ltlf` directory: `cd mltl2ltlf`
2. Install via: `pip install .`
3. The script may be installed to a location not in your `$PATH`. PIP warns you about that. If so, please add the path that pip outputs to your `$PATH` by calling `echo "export PATH=\"/path/pip/warned/you/about:$PATH\"" >> ~/.bashrc && source ~/.bashrc`.
4. `mltl2ltlf` should now be callable from your command line. Navigate back to the root directory: `cd ..`.

#### Installing Lydia

1. Navigate to the `lydia` directory: `cd lydia`
2. Pull the Docker image: `docker pull whitemech/lydia:latest`
3. Make an executable for Lydia: `mkdir -p bin && cd bin && echo "docker run --mount src=/tmp,target=/tmp,type=bind -v$(pwd):/home/default whitemech/lydia lydia \"\$@\"" > lydia && chmod +x lydia && echo "export PATH=$(pwd):$PATH" >> ~/.bashrc && source ~/.bashrc && cd ..`
4. `lydia` should now be callable from your command line. Navigate back to the root directory: `cd ..`.

If you do not have Docker, you can also build Lydia from the source in `lydia`.
Instructions are detailedly given in `lydia/README.md` and have been tested on a recent Ubuntu system.

#### Installing Openllet

1. Navigate into the `openllet` directory.
2. Call `mvn -DskipTests install`.
3. Add `openllet` to your `$PATH`, as the binary is now located in `tools-cli/target/openlletcli/bin`: Execute `echo "export PATH=\"$(pwd)/tools-cli/target/openlletcli/bin:$PATH\"" >> ~/.bashrc && source ~/.bashrc`.
4. `openllet` should now be callable from your command line. Navigate back to the root directory: `cd ..`.

## Running Openllet Temporal Query on all benchmarks

To run Openllet Temporal Query on all benchmarks, please run:

`./execute_benchmarks.sh -c`

Output files will be located in `results`.
Documentation of the benchmark execution script is available by calling `./execute_benchmarks.sh -h`.
Note that executing all benchmarks takes a couple of hours.
For a simple verification of the tool, please use the simple example provided below (cf. "Running Openllet Temporal Query on an example").

### Running Openllet Temporal Query on without the CQ engine improvement

We provide various options that can be passed to `openllet temporal-query` in `config/config_default.properties`.
If you wish to reproduce the benchmarks without the CQ engine improvement, please adapt in `config/config_default.properties` the following lines:

```
TCQ_ENGINE_USE_CQ_ENGINE=true
```
to

```
TCQ_ENGINE_USE_CQ_ENGINE=false
```

However, the raw data for these type of benchmarks are also included in `results/results_wo_cq`.
You can also adapt the timeout by passing `-t 1` to `./execute_benchmarks.sh` (setting it to one hour).

## Running Openllet Temporal Query on an example

Instead of running Openllet Temporal Query on the full benchmark set, you can also play around with it on a small example.

For this, navigate into the examples directory: `cd openllet/examples/src/main/resources/data/tcq`
and call
`export JAVA_OPTS="-Djava.util.logging.config.file=../../../../../../../config/logging.properties" && openllet temporal-query -c catalog-v001.xml -q simple.tcq abox.kbs`.

You can control logging by adapting the file contents of `logging.properties`, or leave out the `export` statement all together for default logging.

## Running Openllet Temporal Query on the test cases

We also provide a large suite of test cases.
To run those, call `mvn -pl tests test -Dtest=TCQTestSuite` from the `openllet` directory.

# Generate benchmarks

*Note: You do not need to re-generate the benchmark files, as they are already delivered in this folder under `benchmarks/aboxes`.
However, if you want to generate more or differently seeded benchmarks, follow these instructions.*

## Installation (to generate TOBM files)

### Prerequisites

We require Python >= 3.10 with PIP to be installed on your system.

#### Installing pyauto 

1. Navigate to the `tobm` directory: `cd tobm`
3. Navigate to the `pyauto` directory: `cd pyauto`
4. Install all requirements: `pip install -r requirements.txt`
5. Install `pyauto`: `pip install .`
5. `pyauto` should now be callable from your command line. Navigate back to the TOBM directory: `cd ..`.

#### Installing TOBM

1. Install all requirements: `pip install -r requirements.txt`
2. Install `tobm`: `pip install .`
3. `tobm` should now be callable from your command line. Navigate back to the root directory: `cd ..`.

## Generating more TOBM files

To generate all benchmark files, run `./generate_benchmarks.sh -c` from this folder.
Documentation of the benchmark generation script is available by calling `./generate_benchmarks.sh -h`.

You can also call `tobm` directly to generate even more benchmark files with other parameters (e.g., lengths or seeds).
Documentation on TOBM is available in `tobm/README.md` or by calling `tobm -h`.
