package openllet.owlapi;

import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;

import openllet.core.utils.progress.ProgressMonitor;

public class ProgressAdapter implements ProgressMonitor
{
	private final ReasonerProgressMonitor _monitor;
	private int _length;
	private int _progress;
	private String _title;

	private volatile int _echo = 0;

	@Override
	public int getLastEcho()
	{
		return _echo;
	}

	public ProgressAdapter(final ReasonerProgressMonitor monitor)
	{
		_monitor = monitor;
		_progress = 0;
		_length = -1;
		_title = "<untitled>";
	}

	@Override
	public int getProgress()
	{
		return _progress;
	}

	@Override
	public int getProgressPercent()
	{

		return _length > 0 ? _progress * 100 / _length : 0;
	}

	@Override
	public void incrementProgress()
	{
		_progress++;
		if (_length > 0)
			_monitor.reasonerTaskProgressChanged(_progress, _length);
		else
			_monitor.reasonerTaskBusy();
	}

	@Override
	public boolean isCanceled()
	{
		return false;
	}

	@Override
	public void setProgress(final int value)
	{
		_progress = value;
		if (_length > 0)
			_monitor.reasonerTaskProgressChanged(_progress, _length);
		else
			_monitor.reasonerTaskBusy();
	}

	@Override
	public void setProgressLength(final int length)
	{
		_length = length;
		if (length > 0)
			_monitor.reasonerTaskProgressChanged(_progress, length);
		else
			_monitor.reasonerTaskBusy();
	}

	@Override
	public void setProgressMessage(final String message)
	{
		//_monitor.setMessage( message );
	}

	@Override
	public void setProgressTitle(final String title)
	{
		_title = title;
	}

	@Override
	public void taskFinished()
	{
		_monitor.reasonerTaskStopped();
	}

	@Override
	public void taskStarted()
	{
		_monitor.reasonerTaskStarted(_title);
	}

}
