/* OWLFunctionalSyntaxParser.java */
/* Generated By:JavaCC: Do not edit this line. OWLFunctionalSyntaxParser.java */
package openllet.owlapi.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.semanticweb.owlapi.formats.FunctionalSyntaxDocumentFormat;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPropertyAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.util.EscapeUtils;
import org.semanticweb.owlapi.util.RemappingIndividualProvider;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWLFacet;

import openllet.atom.OpenError;

@SuppressWarnings("all")
public class OWLFunctionalSyntaxParser implements OWLFunctionalSyntaxParserConstants
{

	private OWLOntologyManager man;

	private OWLOntologyLoaderConfiguration configuration;

	private OWLOntology ontology;

	private OWLDataFactory dataFactory;

	private Map<String, IRI> string2IRI;

	private Map<String, String> prefixMap;

	private IRI ontologyIRI;

	private boolean ignoreAnnotationsAndDeclarations = false;

	private Set<OWLAnnotation> currentAnnotations;

	protected RemappingIndividualProvider anonProvider;

	public void setUp(final OWLOntology ontology, final OWLOntologyLoaderConfiguration configuration)
	{
		man = ontology.getOWLOntologyManager();
		this.ontology = ontology;
		this.configuration = configuration;
		dataFactory = man.getOWLDataFactory();
		anonProvider = new RemappingIndividualProvider(man.getOntologyConfigurator(), dataFactory);
		currentAnnotations = new HashSet<>();
		if (prefixMap == null)
		{
			prefixMap = new HashMap<>();
			prefixMap.put("owl:", Namespaces.OWL.toString());
			prefixMap.put("rdf:", Namespaces.RDF.toString());
			prefixMap.put("rdfs:", Namespaces.RDFS.toString());
			prefixMap.put("xml:", Namespaces.XML.toString());
			prefixMap.put("xsd:", Namespaces.XSD.toString());
		}
		string2IRI = new HashMap<>();
	}

	public IRI getIRI(final String s)
	{
		IRI iri = string2IRI.get(s);
		if (iri == null)
		{
			if (s.charAt(0) == '<')
				iri = IRI.create(s.substring(1, s.length() - 1));
			else
			{
				final int colonIndex = s.indexOf(':');
				final String prefixName = s.substring(0, colonIndex + 1);
				final String prefix = prefixMap.get(prefixName);
				iri = null == prefix ? //
						IRI.create(s) : // raw
						IRI.create(prefix + s.substring(colonIndex + 1)); // fullIRIString
			}
			string2IRI.put(s, iri);
		}
		return iri;
	}

	public void setIgnoreAnnotationsAndDeclarations(final boolean b)
	{
		ignoreAnnotationsAndDeclarations = b;
	}

	protected void applyChange(final OWLOntologyChange chg)
	{
		man.applyChange(chg);
	}

	protected void addAxiom(final OWLAxiom ax)
	{
		if (!(ax instanceof OWLAnnotationAxiom) || configuration.isLoadAnnotationAxioms())
		{
			final AddAxiom addAxiom = new AddAxiom(ontology, ax);
			applyChange(addAxiom);
		}
	}

	public void setPrefixes(final PrefixManager nsm)
	{
		if (prefixMap == null)
			prefixMap = new HashMap<>();
		prefixMap.putAll(nsm.getPrefixName2PrefixMap());
	}

	final public FunctionalSyntaxDocumentFormat parse() throws ParseException, OWLParserException, UnloadableImportException
	{
		label_1: while (true)
		{
			switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
			{
				case PREFIX:
				{

					break;
				}
				default:
					jj_la1[0] = jj_gen;
					break label_1;
			}
			Prefix();
		}
		Ontology();
		jj_consume_token(0);
		final FunctionalSyntaxDocumentFormat format = new FunctionalSyntaxDocumentFormat();
		for (final String pn : prefixMap.keySet())
			format.setPrefix(pn, prefixMap.get(pn));
		{
			if ("" != null)
				return format;
		}
		throw new Error("Missing return statement in function");
	}

	final public void Ontology() throws ParseException, OWLParserException, UnloadableImportException
	{
		OWLAnnotation anno;
		OWLAxiom ax;
		OWLImportsDeclaration decl;
		final int count = 0;
		IRI versionIRI = null;
		jj_consume_token(ONTOLOGY);
		jj_consume_token(OPENPAR);
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case FULLIRI:
			case PNAME_LN:
			{
				ontologyIRI = IRI();
				switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
				{
					case FULLIRI:
					case PNAME_LN:
					{
						versionIRI = IRI();
						break;
					}
					default:
						jj_la1[1] = jj_gen;;
				}
				break;
			}
			default:
				jj_la1[2] = jj_gen;;
		}
		final OWLOntologyID id = new OWLOntologyID(ontologyIRI, versionIRI);
		applyChange(new SetOntologyID(ontology, id));
		label_2: while (true)
		{
			switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
			{
				case IMPORT:
				case ANNOTATION:
				{

					break;
				}
				default:
					jj_la1[3] = jj_gen;
					break label_2;
			}
			switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
			{
				case IMPORT:
				{
					decl = ImportsDeclaration();
					applyChange(new AddImport(ontology, decl));
					man.makeLoadImportRequest(decl, configuration);
					break;
				}
				case ANNOTATION:
				{
					anno = Annotation();
					applyChange(new AddOntologyAnnotation(ontology, anno));
					currentAnnotations.clear();
					break;
				}
				default:
					jj_la1[4] = jj_gen;
					jj_consume_token(-1);
					throw new ParseException();
			}
		}
		label_3: while (true)
		{
			switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
			{
				case SUBCLASSOF:
				case EQUIVALENTCLASSES:
				case DISJOINTCLASSES:
				case DISJOINTUNION:
				case ANNOTATIONASSERTION:
				case SUBANNOTATIONPROPERTYOF:
				case ANNOTATIONPROPERTYDOMAIN:
				case ANNOTATIONPROPERTYRANGE:
				case HASKEY:
				case DECLARATION:
				case INVERSEOBJECTPROPERTIES:
				case DATATYPEDEFINITION:
				case SUBOBJECTPROPERTYOF:
				case EQUIVALENTOBJECTPROPERTIES:
				case DISJOINTOBJECTPROPERTIES:
				case OBJECTPROPERTYDOMAIN:
				case OBJECTPROPERTYRANGE:
				case FUNCTIONALOBJECTPROPERTY:
				case INVERSEFUNCTIONALOBJECTPROPERTY:
				case REFLEXIVEOBJECTPROPERTY:
				case IRREFLEXIVEOBJECTPROPERTY:
				case SYMMETRICOBJECTPROPERTY:
				case ASYMMETRICOBJECTPROPERTY:
				case TRANSITIVEOBJECTPROPERTY:
				case SUBDATAPROPERTYOF:
				case EQUIVALENTDATAPROPERTIES:
				case DISJOINTDATAPROPERTIES:
				case DATAPROPERTYDOMAIN:
				case DATAPROPERTYRANGE:
				case FUNCTIONALDATAPROPERTY:
				case SAMEINDIVIDUAL:
				case DIFFERENTINDIVIDUALS:
				case CLASSASSERTION:
				case OBJECTPROPERTYASSERTION:
				case NEGATIVEOBJECTPROPERTYASSERTION:
				case DATAPROPERTYASSERTION:
				case NEGATIVEDATAPROPERTYASSERTION:
				case DLSAFERULE:
				{

					break;
				}
				default:
					jj_la1[5] = jj_gen;
					break label_3;
			}
			ax = Axiom();
			addAxiom(ax);
			currentAnnotations.clear();
		}
		jj_consume_token(CLOSEPAR);
	}

	final public void Prefix() throws ParseException
	{
		String prefixName = "";
		IRI iri;
		jj_consume_token(PREFIX);
		jj_consume_token(OPENPAR);
		prefixName = PrefixName();
		jj_consume_token(EQUALS);
		iri = FullIRI();
		jj_consume_token(CLOSEPAR);
		prefixMap.put(prefixName, iri.toString());
	}

	final public IRI IRI() throws ParseException
	{
		IRI iri;
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case FULLIRI:
			{
				iri = FullIRI();
				break;
			}
			case PNAME_LN:
			{
				iri = AbbreviatedIRI();
				break;
			}
			default:
				jj_la1[6] = jj_gen;
				jj_consume_token(-1);
				throw new ParseException();
		}
		{
			if ("" != null)
				return iri;
		}
		throw new Error("Missing return statement in function");
	}

	final public IRI FullIRI() throws ParseException
	{
		Token t;
		t = jj_consume_token(FULLIRI);
		{
			if ("" != null)
				return getIRI(t.image);
		}
		throw new Error("Missing return statement in function");
	}

	final public IRI AbbreviatedIRI() throws ParseException
	{
		Token t;
		t = jj_consume_token(PNAME_LN);
		{
			if ("" != null)
				return getIRI(t.image);
		}
		throw new Error("Missing return statement in function");
	}

	final public String PrefixName() throws ParseException
	{
		Token t;
		t = jj_consume_token(PNAME_NS);
		{
			if ("" != null)
				return t.image;
		}
		throw new Error("Missing return statement in function");
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////
	//
	// Class Descriptions
	//
	/////////////////////////////////////////////////////////////////////////////////////////////////////
	final public OWLClassExpression ClassExpression() throws ParseException
	{
		OWLClassExpression desc;
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case FULLIRI:
			case PNAME_LN:
			{
				desc = ClassIRI();
				break;
			}
			case OBJECTUNIONOF:
			{
				desc = ObjectUnionOf();
				break;
			}
			case OBJECTINTERSECTIONOF:
			{
				desc = ObjectIntersectionOf();
				break;
			}
			case OBJECTCOMPLEMENTOF:
			{
				desc = ObjectComplementOf();
				break;
			}
			case OBJECTONEOF:
			{
				desc = ObjectOneOf();
				break;
			}
			case OBJECTSOMEVALUESFROM:
			{
				desc = ObjectSomeValuesFrom();
				break;
			}
			case OBJECTALLVALUESFROM:
			{
				desc = ObjectAllValuesFrom();
				break;
			}
			case OBJECTHASVALUE:
			{
				desc = ObjectHasValue();
				break;
			}
			case OBJECTHASSELF:
			{
				desc = ObjectSelf();
				break;
			}
			case OBJECTMINCARDINALITY:
			{
				desc = ObjectMinCardinality();
				break;
			}
			case OBJECTEXACTCARDINALITY:
			{
				desc = ObjectExactCardinality();
				break;
			}
			case OBJECTMAXCARDINALITY:
			{
				desc = ObjectMaxCardinality();
				break;
			}
			case DATASOMEVALUESFROM:
			{
				desc = DataSomeValuesFrom();
				break;
			}
			case DATAALLVALUESFROM:
			{
				desc = DataAllValuesFrom();
				break;
			}
			case DATAHASVALUE:
			{
				desc = DataHasValue();
				break;
			}
			case DATAMINCARDINALITY:
			{
				desc = DataMinCardinality();
				break;
			}
			case DATAEXACTCARDINALITY:
			{
				desc = DataExactCardinality();
				break;
			}
			case DATAMAXCARDINALITY:
			{
				desc = DataMaxCardinality();
				break;
			}
			default:
				jj_la1[7] = jj_gen;
				jj_consume_token(-1);
				throw new ParseException();
		}
		{
			if ("" != null)
				return desc;
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLClass ClassIRI() throws ParseException
	{
		IRI iri;
		iri = IRI();
		{
			if ("" != null)
				return dataFactory.getOWLClass(iri);
		}
		throw new Error("Missing return statement in function");
	}

	final public Set<OWLClassExpression> ClassExpressionSet() throws ParseException
	{
		final Set<OWLClassExpression> classExpressions = new HashSet<>();
		OWLClassExpression desc;
		desc = ClassExpression();
		classExpressions.add(desc);
		desc = ClassExpression();
		classExpressions.add(desc);
		label_4: while (true)
		{
			switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
			{
				case OBJECTONEOF:
				case OBJECTUNIONOF:
				case OBJECTHASVALUE:
				case OBJECTINTERSECTIONOF:
				case OBJECTCOMPLEMENTOF:
				case OBJECTALLVALUESFROM:
				case OBJECTSOMEVALUESFROM:
				case OBJECTHASSELF:
				case OBJECTMINCARDINALITY:
				case OBJECTMAXCARDINALITY:
				case OBJECTEXACTCARDINALITY:
				case DATAALLVALUESFROM:
				case DATASOMEVALUESFROM:
				case DATAHASVALUE:
				case DATAMINCARDINALITY:
				case DATAMAXCARDINALITY:
				case DATAEXACTCARDINALITY:
				case FULLIRI:
				case PNAME_LN:
				{

					break;
				}
				default:
					jj_la1[8] = jj_gen;
					break label_4;
			}
			desc = ClassExpression();
			classExpressions.add(desc);
		}
		{
			if ("" != null)
				return classExpressions;
		}
		throw new Error("Missing return statement in function");
	}

	final public Set<OWLIndividual> IndividualMinOneSet() throws ParseException
	{
		final Set<OWLIndividual> individuals = new HashSet<>();
		OWLIndividual ind;
		ind = Individual();
		individuals.add(ind);
		label_5: while (true)
		{
			switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
			{
				case FULLIRI:
				case PNAME_LN:
				case NODEID:
				{

					break;
				}
				default:
					jj_la1[9] = jj_gen;
					break label_5;
			}
			ind = Individual();
			individuals.add(ind);
		}
		{
			if ("" != null)
				return individuals;
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLClassExpression ObjectUnionOf() throws ParseException
	{
		Set<OWLClassExpression> classExpressions;
		jj_consume_token(OBJECTUNIONOF);
		jj_consume_token(OPENPAR);
		classExpressions = ClassExpressionSet();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLObjectUnionOf(classExpressions);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLClassExpression ObjectIntersectionOf() throws ParseException
	{
		Set<OWLClassExpression> classExpressions;
		jj_consume_token(OBJECTINTERSECTIONOF);
		jj_consume_token(OPENPAR);
		classExpressions = ClassExpressionSet();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLObjectIntersectionOf(classExpressions);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLClassExpression ObjectComplementOf() throws ParseException
	{
		OWLClassExpression operand;
		jj_consume_token(OBJECTCOMPLEMENTOF);
		jj_consume_token(OPENPAR);
		operand = ClassExpression();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLObjectComplementOf(operand);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLClassExpression ObjectOneOf() throws ParseException
	{
		Set<OWLIndividual> individuals;
		jj_consume_token(OBJECTONEOF);
		jj_consume_token(OPENPAR);
		individuals = IndividualMinOneSet();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLObjectOneOf(individuals);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLClassExpression ObjectAllValuesFrom() throws ParseException
	{
		OWLObjectPropertyExpression prop;
		OWLClassExpression filler;
		jj_consume_token(OBJECTALLVALUESFROM);
		jj_consume_token(OPENPAR);
		prop = ObjectPropertyExpression();
		filler = ClassExpression();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLObjectAllValuesFrom(prop, filler);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLClassExpression ObjectSomeValuesFrom() throws ParseException
	{
		OWLObjectPropertyExpression prop;
		OWLClassExpression filler;
		jj_consume_token(OBJECTSOMEVALUESFROM);
		jj_consume_token(OPENPAR);
		prop = ObjectPropertyExpression();
		filler = ClassExpression();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLObjectSomeValuesFrom(prop, filler);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLClassExpression ObjectHasValue() throws ParseException
	{
		OWLObjectPropertyExpression prop;
		OWLIndividual ind;
		jj_consume_token(OBJECTHASVALUE);
		jj_consume_token(OPENPAR);
		prop = ObjectPropertyExpression();
		ind = Individual();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLObjectHasValue(prop, ind);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLClassExpression ObjectSelf() throws ParseException
	{
		OWLObjectPropertyExpression prop;
		jj_consume_token(OBJECTHASSELF);
		jj_consume_token(OPENPAR);
		prop = ObjectPropertyExpression();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLObjectHasSelf(prop);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLClassExpression ObjectMinCardinality() throws ParseException
	{
		int cardinality = 0;
		OWLObjectPropertyExpression prop = null;
		OWLClassExpression filler = null;
		jj_consume_token(OBJECTMINCARDINALITY);
		jj_consume_token(OPENPAR);
		cardinality = Cardinality();
		prop = ObjectPropertyExpression();
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case OBJECTONEOF:
			case OBJECTUNIONOF:
			case OBJECTHASVALUE:
			case OBJECTINTERSECTIONOF:
			case OBJECTCOMPLEMENTOF:
			case OBJECTALLVALUESFROM:
			case OBJECTSOMEVALUESFROM:
			case OBJECTHASSELF:
			case OBJECTMINCARDINALITY:
			case OBJECTMAXCARDINALITY:
			case OBJECTEXACTCARDINALITY:
			case DATAALLVALUESFROM:
			case DATASOMEVALUESFROM:
			case DATAHASVALUE:
			case DATAMINCARDINALITY:
			case DATAMAXCARDINALITY:
			case DATAEXACTCARDINALITY:
			case FULLIRI:
			case PNAME_LN:
			{
				filler = ClassExpression();
				break;
			}
			default:
				jj_la1[10] = jj_gen;;
		}
		jj_consume_token(CLOSEPAR);
		if (filler == null)
		{
			if ("" != null)
				return dataFactory.getOWLObjectMinCardinality(cardinality, prop);
		}
		else
			if ("" != null)
				return dataFactory.getOWLObjectMinCardinality(cardinality, prop, filler);
		throw new Error("Missing return statement in function");
	}

	final public OWLClassExpression ObjectExactCardinality() throws ParseException
	{
		int cardinality = 0;
		OWLObjectPropertyExpression prop = null;
		OWLClassExpression filler = null;
		jj_consume_token(OBJECTEXACTCARDINALITY);
		jj_consume_token(OPENPAR);
		cardinality = Cardinality();
		prop = ObjectPropertyExpression();
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case OBJECTONEOF:
			case OBJECTUNIONOF:
			case OBJECTHASVALUE:
			case OBJECTINTERSECTIONOF:
			case OBJECTCOMPLEMENTOF:
			case OBJECTALLVALUESFROM:
			case OBJECTSOMEVALUESFROM:
			case OBJECTHASSELF:
			case OBJECTMINCARDINALITY:
			case OBJECTMAXCARDINALITY:
			case OBJECTEXACTCARDINALITY:
			case DATAALLVALUESFROM:
			case DATASOMEVALUESFROM:
			case DATAHASVALUE:
			case DATAMINCARDINALITY:
			case DATAMAXCARDINALITY:
			case DATAEXACTCARDINALITY:
			case FULLIRI:
			case PNAME_LN:
			{
				filler = ClassExpression();
				break;
			}
			default:
				jj_la1[11] = jj_gen;;
		}
		jj_consume_token(CLOSEPAR);
		if (filler == null)
		{
			if ("" != null)
				return dataFactory.getOWLObjectExactCardinality(cardinality, prop);
		}
		else
			if ("" != null)
				return dataFactory.getOWLObjectExactCardinality(cardinality, prop, filler);
		throw new Error("Missing return statement in function");
	}

	final public OWLClassExpression ObjectMaxCardinality() throws ParseException
	{
		int cardinality = 0;
		OWLObjectPropertyExpression prop = null;
		OWLClassExpression filler = null;
		jj_consume_token(OBJECTMAXCARDINALITY);
		jj_consume_token(OPENPAR);
		cardinality = Cardinality();
		prop = ObjectPropertyExpression();
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case OBJECTONEOF:
			case OBJECTUNIONOF:
			case OBJECTHASVALUE:
			case OBJECTINTERSECTIONOF:
			case OBJECTCOMPLEMENTOF:
			case OBJECTALLVALUESFROM:
			case OBJECTSOMEVALUESFROM:
			case OBJECTHASSELF:
			case OBJECTMINCARDINALITY:
			case OBJECTMAXCARDINALITY:
			case OBJECTEXACTCARDINALITY:
			case DATAALLVALUESFROM:
			case DATASOMEVALUESFROM:
			case DATAHASVALUE:
			case DATAMINCARDINALITY:
			case DATAMAXCARDINALITY:
			case DATAEXACTCARDINALITY:
			case FULLIRI:
			case PNAME_LN:
			{
				filler = ClassExpression();
				break;
			}
			default:
				jj_la1[12] = jj_gen;;
		}
		jj_consume_token(CLOSEPAR);
		if (filler == null)
		{
			if ("" != null)
				return dataFactory.getOWLObjectMaxCardinality(cardinality, prop);
		}
		else
			if ("" != null)
				return dataFactory.getOWLObjectMaxCardinality(cardinality, prop, filler);
		throw new Error("Missing return statement in function");
	}

	final public OWLClassExpression DataAllValuesFrom() throws ParseException
	{
		OWLDataPropertyExpression prop = null;
		OWLDataRange dataRange = null;
		jj_consume_token(DATAALLVALUESFROM);
		jj_consume_token(OPENPAR);
		prop = DataPropertyExpression();
		dataRange = DataRange();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLDataAllValuesFrom(prop, dataRange);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLClassExpression DataSomeValuesFrom() throws ParseException
	{
		OWLDataPropertyExpression prop = null;
		OWLDataRange dataRange = null;
		jj_consume_token(DATASOMEVALUESFROM);
		jj_consume_token(OPENPAR);
		prop = DataPropertyExpression();
		dataRange = DataRange();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLDataSomeValuesFrom(prop, dataRange);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLClassExpression DataHasValue() throws ParseException
	{
		OWLDataPropertyExpression prop = null;
		OWLLiteral literal = null;
		jj_consume_token(DATAHASVALUE);
		jj_consume_token(OPENPAR);
		prop = DataPropertyExpression();
		literal = Literal();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLDataHasValue(prop, literal);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLClassExpression DataMinCardinality() throws ParseException
	{
		int cardinality = 0;
		OWLDataPropertyExpression prop = null;
		OWLDataRange rng = null;
		jj_consume_token(DATAMINCARDINALITY);
		jj_consume_token(OPENPAR);
		cardinality = Cardinality();
		prop = DataPropertyExpression();
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case DATAONEOF:
			case DATAUNIONOF:
			case DATAINTERSECTIONOF:
			case DATACOMPLEMENTOF:
			case DATATYPERESTRICTION:
			case FULLIRI:
			case PNAME_LN:
			{
				rng = DataRange();
				break;
			}
			default:
				jj_la1[13] = jj_gen;;
		}
		jj_consume_token(CLOSEPAR);
		if (rng == null)
		{
			if ("" != null)
				return dataFactory.getOWLDataMinCardinality(cardinality, prop);
		}
		else
			if ("" != null)
				return dataFactory.getOWLDataMinCardinality(cardinality, prop, rng);
		throw new Error("Missing return statement in function");
	}

	final public OWLClassExpression DataExactCardinality() throws ParseException
	{
		int cardinality = 0;
		OWLDataPropertyExpression prop = null;
		OWLDataRange rng = null;
		jj_consume_token(DATAEXACTCARDINALITY);
		jj_consume_token(OPENPAR);
		cardinality = Cardinality();
		prop = DataPropertyExpression();
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case DATAONEOF:
			case DATAUNIONOF:
			case DATAINTERSECTIONOF:
			case DATACOMPLEMENTOF:
			case DATATYPERESTRICTION:
			case FULLIRI:
			case PNAME_LN:
			{
				rng = DataRange();
				break;
			}
			default:
				jj_la1[14] = jj_gen;;
		}
		jj_consume_token(CLOSEPAR);
		if (rng == null)
		{
			if ("" != null)
				return dataFactory.getOWLDataExactCardinality(cardinality, prop);
		}
		else
			if ("" != null)
				return dataFactory.getOWLDataExactCardinality(cardinality, prop, rng);
		throw new Error("Missing return statement in function");
	}

	final public OWLClassExpression DataMaxCardinality() throws ParseException
	{
		int cardinality = 0;
		OWLDataPropertyExpression prop = null;
		OWLDataRange rng = null;
		jj_consume_token(DATAMAXCARDINALITY);
		jj_consume_token(OPENPAR);
		cardinality = Cardinality();
		prop = DataPropertyExpression();
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case DATAONEOF:
			case DATAUNIONOF:
			case DATAINTERSECTIONOF:
			case DATACOMPLEMENTOF:
			case DATATYPERESTRICTION:
			case FULLIRI:
			case PNAME_LN:
			{
				rng = DataRange();
				break;
			}
			default:
				jj_la1[15] = jj_gen;;
		}
		jj_consume_token(CLOSEPAR);
		if (rng == null)
		{
			if ("" != null)
				return dataFactory.getOWLDataMaxCardinality(cardinality, prop);
		}
		else
			if ("" != null)
				return dataFactory.getOWLDataMaxCardinality(cardinality, prop, rng);
		throw new Error("Missing return statement in function");
	}

	final public OWLClass Class() throws ParseException
	{
		OWLClass cls;
		jj_consume_token(CLASS);
		jj_consume_token(OPENPAR);
		cls = ClassIRI();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return cls;
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLObjectPropertyExpression ObjectPropertyExpression() throws ParseException
	{
		OWLObjectPropertyExpression prop;
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case OBJECTINVERSEOF:
			{
				prop = InverseObjectProperty();
				break;
			}
			case FULLIRI:
			case PNAME_LN:
			{
				prop = ObjectPropertyIRI();
				break;
			}
			default:
				jj_la1[16] = jj_gen;
				jj_consume_token(-1);
				throw new ParseException();
		}
		{
			if ("" != null)
				return prop;
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLObjectPropertyExpression InverseObjectProperty() throws ParseException
	{
		OWLObjectProperty prop;
		jj_consume_token(OBJECTINVERSEOF);
		jj_consume_token(OPENPAR);
		prop = ObjectPropertyIRI();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLObjectInverseOf(prop);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLObjectProperty ObjectProperty() throws ParseException
	{
		OWLObjectProperty prop;
		jj_consume_token(OBJECTPROP);
		jj_consume_token(OPENPAR);
		prop = ObjectPropertyIRI();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return prop;
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLDataPropertyExpression DataPropertyExpression() throws ParseException
	{
		OWLDataPropertyExpression prop;
		prop = DataPropertyIRI();
		{
			if ("" != null)
				return prop;
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLDataProperty DataPropertyIRI() throws ParseException
	{
		IRI iri;
		iri = IRI();
		{
			if ("" != null)
				return dataFactory.getOWLDataProperty(iri);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLDataProperty DataProperty() throws ParseException
	{
		OWLDataProperty prop;
		jj_consume_token(DATAPROP);
		jj_consume_token(OPENPAR);
		prop = DataPropertyIRI();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return prop;
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLAnnotationProperty AnnotationProperty() throws ParseException
	{
		OWLAnnotationProperty prop;
		jj_consume_token(ANNOTATIONPROPERTY);
		jj_consume_token(OPENPAR);
		prop = AnnotationPropertyIRI();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return prop;
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLAnnotationProperty AnnotationPropertyIRI() throws ParseException
	{
		IRI iri;
		iri = IRI();
		{
			if ("" != null)
				return dataFactory.getOWLAnnotationProperty(iri);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLNamedIndividual NamedIndividual() throws ParseException
	{
		OWLNamedIndividual ind;
		jj_consume_token(NAMEDINDIVIDUAL);
		jj_consume_token(OPENPAR);
		ind = IndividualIRI();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return ind;
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLAnonymousIndividual AnonymousIndividual() throws ParseException
	{
		Token t;
		t = jj_consume_token(NODEID);
		final String id = t.image.substring(2, t.image.length());
		{
			if ("" != null)
				return anonProvider.getOWLAnonymousIndividual(id);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLDatatype Datatype() throws ParseException
	{
		OWLDatatype dt;
		jj_consume_token(DATATYPE);
		jj_consume_token(OPENPAR);
		dt = DatatypeIRI();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dt;
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLDatatype DatatypeIRI() throws ParseException
	{
		IRI iri;
		iri = IRI();
		{
			if ("" != null)
				return dataFactory.getOWLDatatype(iri);
		}
		throw new Error("Missing return statement in function");
	}

	final public int Cardinality() throws ParseException
	{
		int card = 0;
		card = Integer();
		{
			if ("" != null)
				return card;
		}
		throw new Error("Missing return statement in function");
	}

	final public int Integer() throws ParseException
	{
		Token t;
		t = jj_consume_token(INT);
		final int i = Integer.parseInt(t.image);
		{
			if ("" != null)
				return i;
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLDatatypeDefinitionAxiom DatatypeDefinitionAxiom() throws ParseException
	{
		OWLDatatype datatype;
		OWLDataRange dr;
		Set<OWLAnnotation> axAnnos;
		jj_consume_token(DATATYPEDEFINITION);
		jj_consume_token(OPENPAR);
		axAnnos = AxiomAnnotationSet();
		datatype = DatatypeIRI();
		dr = DataRange();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLDatatypeDefinitionAxiom(datatype, dr, axAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLDataRange DataRange() throws ParseException
	{
		OWLDataRange rng;
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case FULLIRI:
			case PNAME_LN:
			{
				rng = DatatypeIRI();
				break;
			}
			case DATAONEOF:
			{
				rng = DataOneOf();
				break;
			}
			case DATACOMPLEMENTOF:
			{
				rng = DataComplementOf();
				break;
			}
			case DATATYPERESTRICTION:
			{
				rng = DataRangeRestriction();
				break;
			}
			case DATAINTERSECTIONOF:
			{
				rng = DataIntersectionOf();
				break;
			}
			case DATAUNIONOF:
			{
				rng = DataUnionOf();
				break;
			}
			default:
				jj_la1[17] = jj_gen;
				jj_consume_token(-1);
				throw new ParseException();
		}
		{
			if ("" != null)
				return rng;
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLDataRange DataComplementOf() throws ParseException
	{
		OWLDataRange rng;
		jj_consume_token(DATACOMPLEMENTOF);
		jj_consume_token(OPENPAR);
		rng = DataRange();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLDataComplementOf(rng);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLDataRange DataOneOf() throws ParseException
	{
		final Set<OWLLiteral> values = new HashSet<>();
		OWLLiteral con = null;
		final OWLDataRange rng = null;
		jj_consume_token(DATAONEOF);
		jj_consume_token(OPENPAR);
		label_6: while (true)
		{
			con = Literal();
			values.add(con);
			switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
			{
				case STRINGLITERAL:
				{

					break;
				}
				default:
					jj_la1[18] = jj_gen;
					break label_6;
			}
		}
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLDataOneOf(values);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLDataRange DataUnionOf() throws ParseException
	{
		OWLDataRange dataRange;
		final Set<OWLDataRange> ranges = new HashSet<>();
		jj_consume_token(DATAUNIONOF);
		jj_consume_token(OPENPAR);
		label_7: while (true)
		{
			dataRange = DataRange();
			ranges.add(dataRange);
			switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
			{
				case DATAONEOF:
				case DATAUNIONOF:
				case DATAINTERSECTIONOF:
				case DATACOMPLEMENTOF:
				case DATATYPERESTRICTION:
				case FULLIRI:
				case PNAME_LN:
				{

					break;
				}
				default:
					jj_la1[19] = jj_gen;
					break label_7;
			}
		}
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLDataUnionOf(ranges);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLDataRange DataIntersectionOf() throws ParseException
	{
		OWLDataRange dataRange;
		final Set<OWLDataRange> ranges = new HashSet<>();
		jj_consume_token(DATAINTERSECTIONOF);
		jj_consume_token(OPENPAR);
		label_8: while (true)
		{
			dataRange = DataRange();
			ranges.add(dataRange);
			switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
			{
				case DATAONEOF:
				case DATAUNIONOF:
				case DATAINTERSECTIONOF:
				case DATACOMPLEMENTOF:
				case DATATYPERESTRICTION:
				case FULLIRI:
				case PNAME_LN:
				{

					break;
				}
				default:
					jj_la1[20] = jj_gen;
					break label_8;
			}
		}
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLDataIntersectionOf(ranges);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLDataRange DataRangeRestriction() throws ParseException
	{
		final OWLFacet v;
		OWLDatatype rng;
		OWLFacetRestriction facetRestriction;
		final Set<OWLFacetRestriction> facetRestrictions = new HashSet<>();
		jj_consume_token(DATATYPERESTRICTION);
		jj_consume_token(OPENPAR);
		rng = DatatypeIRI();
		label_9: while (true)
		{
			facetRestriction = DataRangeFacetRestriction();
			facetRestrictions.add(facetRestriction);
			switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
			{
				case FULLIRI:
				case PNAME_LN:
				{

					break;
				}
				default:
					jj_la1[21] = jj_gen;
					break label_9;
			}
		}
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLDatatypeRestriction(rng, facetRestrictions);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLFacetRestriction DataRangeFacetRestriction() throws ParseException
	{
		IRI iri;
		OWLLiteral con;
		iri = IRI();
		con = Literal();
		final OWLFacet v = OWLFacet.getFacetByShortName(iri.getFragment());
		{
			if ("" != null)
				return dataFactory.getOWLFacetRestriction(v, con);
		}
		throw new Error("Missing return statement in function");
	}

	///////////////////////////////////////////////////////////////////////////////////////////////////////////
	//
	// Axioms
	//
	///////////////////////////////////////////////////////////////////////////////////////////////////////////
	final public OWLAxiom Axiom() throws ParseException
	{
		OWLAxiom ax = null;
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case SUBCLASSOF:
			case EQUIVALENTCLASSES:
			case DISJOINTCLASSES:
			case DISJOINTUNION:
			{
				ax = ClassAxiom();
				break;
			}
			case INVERSEOBJECTPROPERTIES:
			case SUBOBJECTPROPERTYOF:
			case EQUIVALENTOBJECTPROPERTIES:
			case DISJOINTOBJECTPROPERTIES:
			case OBJECTPROPERTYDOMAIN:
			case OBJECTPROPERTYRANGE:
			case FUNCTIONALOBJECTPROPERTY:
			case INVERSEFUNCTIONALOBJECTPROPERTY:
			case REFLEXIVEOBJECTPROPERTY:
			case IRREFLEXIVEOBJECTPROPERTY:
			case SYMMETRICOBJECTPROPERTY:
			case ASYMMETRICOBJECTPROPERTY:
			case TRANSITIVEOBJECTPROPERTY:
			{
				ax = ObjectPropertyAxiom();
				break;
			}
			case SUBDATAPROPERTYOF:
			case EQUIVALENTDATAPROPERTIES:
			case DISJOINTDATAPROPERTIES:
			case DATAPROPERTYDOMAIN:
			case DATAPROPERTYRANGE:
			case FUNCTIONALDATAPROPERTY:
			{
				ax = DataPropertyAxiom();
				break;
			}
			case SAMEINDIVIDUAL:
			case DIFFERENTINDIVIDUALS:
			case CLASSASSERTION:
			case OBJECTPROPERTYASSERTION:
			case NEGATIVEOBJECTPROPERTYASSERTION:
			case DATAPROPERTYASSERTION:
			case NEGATIVEDATAPROPERTYASSERTION:
			{
				ax = IndividualAxiom();
				break;
			}
			case DECLARATION:
			{
				ax = Declaration();
				break;
			}
			case HASKEY:
			{
				ax = HasKey();
				break;
			}
			case DATATYPEDEFINITION:
			{
				ax = DatatypeDefinitionAxiom();
				break;
			}
			case ANNOTATIONASSERTION:
			case SUBANNOTATIONPROPERTYOF:
			case ANNOTATIONPROPERTYDOMAIN:
			case ANNOTATIONPROPERTYRANGE:
			{
				ax = AnnotationAxiom();
				break;
			}
			case DLSAFERULE:
			{
				ax = DLSafeRule();
				break;
			}
			default:
				jj_la1[22] = jj_gen;
				jj_consume_token(-1);
				throw new ParseException();
		}
		{
			if ("" != null)
				return ax;
		}
		throw new Error("Missing return statement in function");
	}

	///////////////////////////////////////////////////////////////////////////////////////////////////////////
	//
	// Class Axioms
	//
	///////////////////////////////////////////////////////////////////////////////////////////////////////////
	final public OWLClassAxiom ClassAxiom() throws ParseException
	{
		OWLClassAxiom ax;
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case SUBCLASSOF:
			{
				ax = SubClassOf();
				break;
			}
			case EQUIVALENTCLASSES:
			{
				ax = EquivalentClasses();
				break;
			}
			case DISJOINTCLASSES:
			{
				ax = DisjointClasses();
				break;
			}
			case DISJOINTUNION:
			{
				ax = DisjointUnion();
				break;
			}
			default:
				jj_la1[23] = jj_gen;
				jj_consume_token(-1);
				throw new ParseException();
		}
		{
			if ("" != null)
				return ax;
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLClassAxiom SubClassOf() throws ParseException
	{
		OWLClassExpression subClass;
		OWLClassExpression superClass;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(SUBCLASSOF);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		subClass = ClassExpression();
		superClass = ClassExpression();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLSubClassOfAxiom(subClass, superClass, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLClassAxiom EquivalentClasses() throws ParseException
	{
		Set<OWLClassExpression> classExpressions;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(EQUIVALENTCLASSES);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		classExpressions = ClassExpressionSet();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLEquivalentClassesAxiom(classExpressions, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLClassAxiom DisjointClasses() throws ParseException
	{
		Set<OWLClassExpression> classExpressions;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(DISJOINTCLASSES);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		classExpressions = ClassExpressionSet();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLDisjointClassesAxiom(classExpressions, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLClassAxiom DisjointUnion() throws ParseException
	{
		OWLClass cls;
		Set<OWLClassExpression> classExpressions;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(DISJOINTUNION);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		cls = ClassIRI();
		classExpressions = ClassExpressionSet();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLDisjointUnionAxiom(cls, classExpressions, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	///////////////////////////////////////////////////////////////////////////////////////////////////////////
	//
	// Object Property Axioms
	//
	///////////////////////////////////////////////////////////////////////////////////////////////////////////
	final public OWLPropertyAxiom ObjectPropertyAxiom() throws ParseException
	{
		OWLPropertyAxiom ax;
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case SUBOBJECTPROPERTYOF:
			{
				ax = SubObjectPropertyOf();
				break;
			}
			case EQUIVALENTOBJECTPROPERTIES:
			{
				ax = EquivalentObjectProperties();
				break;
			}
			case DISJOINTOBJECTPROPERTIES:
			{
				ax = DisjointObjectProperties();
				break;
			}
			case OBJECTPROPERTYRANGE:
			{
				ax = ObjectPropertyRange();
				break;
			}
			case OBJECTPROPERTYDOMAIN:
			{
				ax = ObjectPropertyDomain();
				break;
			}
			case FUNCTIONALOBJECTPROPERTY:
			{
				ax = FunctionalObjectProperty();
				break;
			}
			case INVERSEFUNCTIONALOBJECTPROPERTY:
			{
				ax = InverseFunctionalObjectProperty();
				break;
			}
			case SYMMETRICOBJECTPROPERTY:
			{
				ax = SymmetricObjectProperty();
				break;
			}
			case ASYMMETRICOBJECTPROPERTY:
			{
				ax = AsymmetricObjectProperty();
				break;
			}
			case REFLEXIVEOBJECTPROPERTY:
			{
				ax = ReflexiveObjectProperty();
				break;
			}
			case IRREFLEXIVEOBJECTPROPERTY:
			{
				ax = IrreflexiveObjectProperty();
				break;
			}
			case TRANSITIVEOBJECTPROPERTY:
			{
				ax = TransitiveObjectProperty();
				break;
			}
			case INVERSEOBJECTPROPERTIES:
			{
				ax = InverseObjectProperties();
				break;
			}
			default:
				jj_la1[24] = jj_gen;
				jj_consume_token(-1);
				throw new ParseException();
		}
		{
			if ("" != null)
				return ax;
		}
		throw new Error("Missing return statement in function");
	}

	final public List<OWLObjectPropertyExpression> SubObjectPropertyChain() throws ParseException
	{
		OWLObjectPropertyExpression prop;
		final List<OWLObjectPropertyExpression> props = new ArrayList<>();
		jj_consume_token(SUBOBJECTPROPERTYCHAIN);
		jj_consume_token(OPENPAR);
		prop = ObjectPropertyExpression();
		props.add(prop);
		label_10: while (true)
		{
			switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
			{
				case OBJECTINVERSEOF:
				case FULLIRI:
				case PNAME_LN:
				{

					break;
				}
				default:
					jj_la1[25] = jj_gen;
					break label_10;
			}
			prop = ObjectPropertyExpression();
			props.add(prop);
		}
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return props;
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLPropertyAxiom SubObjectPropertyOf() throws ParseException
	{
		OWLObjectPropertyExpression subProperty = null;
		List<OWLObjectPropertyExpression> chain = null;
		OWLObjectPropertyExpression superProperty = null;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(SUBOBJECTPROPERTYOF);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case OBJECTINVERSEOF:
			case FULLIRI:
			case PNAME_LN:
			{
				subProperty = ObjectPropertyExpression();
				break;
			}
			case SUBOBJECTPROPERTYCHAIN:
			{
				chain = SubObjectPropertyChain();
				break;
			}
			default:
				jj_la1[26] = jj_gen;
				jj_consume_token(-1);
				throw new ParseException();
		}
		superProperty = ObjectPropertyExpression();
		jj_consume_token(CLOSEPAR);
		if (subProperty != null)
		{
			if ("" != null)
				return dataFactory.getOWLSubObjectPropertyOfAxiom(subProperty, superProperty, axiomAnnos);
		}
		else
			if (chain != null)
			{
				if ("" != null)
					return dataFactory.getOWLSubPropertyChainOfAxiom(chain, superProperty, axiomAnnos);
			}
			else
				if ("" != null)
					return null;
		throw new Error("Missing return statement in function");
	}

	final public OWLPropertyAxiom EquivalentObjectProperties() throws ParseException
	{
		Set<OWLObjectPropertyExpression> props;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(EQUIVALENTOBJECTPROPERTIES);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		props = ObjectPropertySet();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLEquivalentObjectPropertiesAxiom(props, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLPropertyAxiom DisjointObjectProperties() throws ParseException
	{
		Set<OWLObjectPropertyExpression> props;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(DISJOINTOBJECTPROPERTIES);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		props = ObjectPropertySet();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLDisjointObjectPropertiesAxiom(props, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public Set<OWLObjectPropertyExpression> ObjectPropertySet() throws ParseException
	{
		OWLObjectPropertyExpression prop;
		final Set<OWLObjectPropertyExpression> props = new HashSet<>();
		prop = ObjectPropertyExpression();
		props.add(prop);
		prop = ObjectPropertyExpression();
		props.add(prop);
		label_11: while (true)
		{
			switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
			{
				case OBJECTINVERSEOF:
				case FULLIRI:
				case PNAME_LN:
				{

					break;
				}
				default:
					jj_la1[27] = jj_gen;
					break label_11;
			}
			prop = ObjectPropertyExpression();
			props.add(prop);
		}
		{
			if ("" != null)
				return props;
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLPropertyAxiom ObjectPropertyRange() throws ParseException
	{
		OWLObjectPropertyExpression prop;
		OWLClassExpression range;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(OBJECTPROPERTYRANGE);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		prop = ObjectPropertyExpression();
		range = ClassExpression();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLObjectPropertyRangeAxiom(prop, range, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLPropertyAxiom ObjectPropertyDomain() throws ParseException
	{
		OWLObjectPropertyExpression prop;
		OWLClassExpression desc;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(OBJECTPROPERTYDOMAIN);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		prop = ObjectPropertyExpression();
		desc = ClassExpression();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLObjectPropertyDomainAxiom(prop, desc, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLPropertyAxiom FunctionalObjectProperty() throws ParseException
	{
		OWLObjectPropertyExpression prop;
		Set<OWLAnnotation> axiomAnnos = Collections.emptySet();
		jj_consume_token(FUNCTIONALOBJECTPROPERTY);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		prop = ObjectPropertyExpression();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLFunctionalObjectPropertyAxiom(prop, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLPropertyAxiom InverseObjectProperties() throws ParseException
	{
		OWLObjectPropertyExpression propA;
		OWLObjectPropertyExpression propB;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(INVERSEOBJECTPROPERTIES);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		propA = ObjectPropertyExpression();
		propB = ObjectPropertyExpression();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLInverseObjectPropertiesAxiom(propA, propB, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLPropertyAxiom InverseFunctionalObjectProperty() throws ParseException
	{
		OWLObjectPropertyExpression prop;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(INVERSEFUNCTIONALOBJECTPROPERTY);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		prop = ObjectPropertyExpression();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLInverseFunctionalObjectPropertyAxiom(prop, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLPropertyAxiom SymmetricObjectProperty() throws ParseException
	{
		OWLObjectPropertyExpression prop;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(SYMMETRICOBJECTPROPERTY);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		prop = ObjectPropertyExpression();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLSymmetricObjectPropertyAxiom(prop, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLPropertyAxiom AsymmetricObjectProperty() throws ParseException
	{
		OWLObjectPropertyExpression prop;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(ASYMMETRICOBJECTPROPERTY);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		prop = ObjectPropertyExpression();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLAsymmetricObjectPropertyAxiom(prop, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLPropertyAxiom ReflexiveObjectProperty() throws ParseException
	{
		OWLObjectPropertyExpression prop;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(REFLEXIVEOBJECTPROPERTY);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		prop = ObjectPropertyExpression();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLReflexiveObjectPropertyAxiom(prop, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLPropertyAxiom IrreflexiveObjectProperty() throws ParseException
	{
		OWLObjectPropertyExpression prop;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(IRREFLEXIVEOBJECTPROPERTY);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		prop = ObjectPropertyExpression();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLIrreflexiveObjectPropertyAxiom(prop, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLPropertyAxiom TransitiveObjectProperty() throws ParseException
	{
		OWLObjectPropertyExpression prop;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(TRANSITIVEOBJECTPROPERTY);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		prop = ObjectPropertyExpression();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLTransitiveObjectPropertyAxiom(prop, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	///////////////////////////////////////////////////////////////////////////////////////////////////////////
	//
	// Data Property Axioms
	//
	///////////////////////////////////////////////////////////////////////////////////////////////////////////
	final public OWLPropertyAxiom DataPropertyAxiom() throws ParseException
	{
		OWLPropertyAxiom ax;
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case SUBDATAPROPERTYOF:
			{
				ax = SubDataPropertyOf();
				break;
			}
			case EQUIVALENTDATAPROPERTIES:
			{
				ax = EquivalentDataProperties();
				break;
			}
			case DISJOINTDATAPROPERTIES:
			{
				ax = DisjointDataProperties();
				break;
			}
			case DATAPROPERTYRANGE:
			{
				ax = DataPropertyRange();
				break;
			}
			case DATAPROPERTYDOMAIN:
			{
				ax = DataPropertyDomain();
				break;
			}
			case FUNCTIONALDATAPROPERTY:
			{
				ax = FunctionalDataProperty();
				break;
			}
			default:
				jj_la1[28] = jj_gen;
				jj_consume_token(-1);
				throw new ParseException();
		}
		{
			if ("" != null)
				return ax;
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLPropertyAxiom SubDataPropertyOf() throws ParseException
	{
		OWLDataPropertyExpression subProperty;
		OWLDataPropertyExpression superProperty;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(SUBDATAPROPERTYOF);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		subProperty = DataPropertyExpression();
		superProperty = DataPropertyExpression();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLSubDataPropertyOfAxiom(subProperty, superProperty, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLPropertyAxiom EquivalentDataProperties() throws ParseException
	{
		Set<OWLDataPropertyExpression> props;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(EQUIVALENTDATAPROPERTIES);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		props = DataPropertySet();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLEquivalentDataPropertiesAxiom(props, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLPropertyAxiom DisjointDataProperties() throws ParseException
	{
		Set<OWLDataPropertyExpression> props;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(DISJOINTDATAPROPERTIES);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		props = DataPropertySet();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLDisjointDataPropertiesAxiom(props, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public Set<OWLDataPropertyExpression> DataPropertySet() throws ParseException
	{
		OWLDataPropertyExpression prop;
		final Set<OWLDataPropertyExpression> props = new HashSet<>();
		prop = DataPropertyExpression();
		props.add(prop);
		prop = DataPropertyExpression();
		props.add(prop);
		label_12: while (true)
		{
			switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
			{
				case FULLIRI:
				case PNAME_LN:
				{

					break;
				}
				default:
					jj_la1[29] = jj_gen;
					break label_12;
			}
			prop = DataPropertyExpression();
			props.add(prop);
		}
		{
			if ("" != null)
				return props;
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLPropertyAxiom DataPropertyDomain() throws ParseException
	{
		OWLDataPropertyExpression prop;
		OWLClassExpression domain;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(DATAPROPERTYDOMAIN);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		prop = DataPropertyExpression();
		domain = ClassExpression();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLDataPropertyDomainAxiom(prop, domain, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLPropertyAxiom DataPropertyRange() throws ParseException
	{
		OWLDataPropertyExpression prop;
		OWLDataRange rng;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(DATAPROPERTYRANGE);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		prop = DataPropertyExpression();
		rng = DataRange();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLDataPropertyRangeAxiom(prop, rng, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLPropertyAxiom FunctionalDataProperty() throws ParseException
	{
		OWLDataPropertyExpression prop;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(FUNCTIONALDATAPROPERTY);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		prop = DataPropertyExpression();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLFunctionalDataPropertyAxiom(prop, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	///////////////////////////////////////////////////////////////////////////////////////////////////////////
	//
	// Individual Axioms
	//
	///////////////////////////////////////////////////////////////////////////////////////////////////////////
	final public OWLIndividualAxiom IndividualAxiom() throws ParseException
	{
		OWLIndividualAxiom ax;
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case SAMEINDIVIDUAL:
			{
				ax = SameIndividuals();
				break;
			}
			case DIFFERENTINDIVIDUALS:
			{
				ax = DifferentIndividuals();
				break;
			}
			case CLASSASSERTION:
			{
				ax = ClassAssertion();
				break;
			}
			case OBJECTPROPERTYASSERTION:
			{
				ax = ObjectPropertyAssertion();
				break;
			}
			case DATAPROPERTYASSERTION:
			{
				ax = DataPropertyAssertion();
				break;
			}
			case NEGATIVEOBJECTPROPERTYASSERTION:
			{
				ax = NegativeObjectPropertyAssertion();
				break;
			}
			case NEGATIVEDATAPROPERTYASSERTION:
			{
				ax = NegativeDataPropertyAssertion();
				break;
			}
			default:
				jj_la1[30] = jj_gen;
				jj_consume_token(-1);
				throw new ParseException();
		}
		{
			if ("" != null)
				return ax;
		}
		throw new Error("Missing return statement in function");
	}

	final public Set<OWLIndividual> IndividualSet() throws ParseException
	{
		OWLIndividual ind;
		final Set<OWLIndividual> individuals = new HashSet<>();
		ind = Individual();
		individuals.add(ind);
		ind = Individual();
		individuals.add(ind);
		label_13: while (true)
		{
			switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
			{
				case FULLIRI:
				case PNAME_LN:
				case NODEID:
				{

					break;
				}
				default:
					jj_la1[31] = jj_gen;
					break label_13;
			}
			ind = Individual();
			individuals.add(ind);
		}
		{
			if ("" != null)
				return individuals;
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLIndividualAxiom SameIndividuals() throws ParseException
	{
		Set<OWLIndividual> individuals;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(SAMEINDIVIDUAL);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		individuals = IndividualSet();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLSameIndividualAxiom(individuals, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLIndividualAxiom DifferentIndividuals() throws ParseException
	{
		Set<OWLIndividual> individuals;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(DIFFERENTINDIVIDUALS);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		individuals = IndividualSet();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLDifferentIndividualsAxiom(individuals, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLIndividualAxiom ClassAssertion() throws ParseException
	{
		OWLIndividual ind;
		OWLClassExpression desc;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(CLASSASSERTION);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		desc = ClassExpression();
		ind = Individual();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLClassAssertionAxiom(desc, ind, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLIndividualAxiom ObjectPropertyAssertion() throws ParseException
	{
		OWLIndividual subj;
		OWLObjectPropertyExpression prop;
		OWLIndividual obj;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(OBJECTPROPERTYASSERTION);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		prop = ObjectPropertyExpression();
		subj = Individual();
		obj = Individual();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLObjectPropertyAssertionAxiom(prop, subj, obj, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLIndividualAxiom NegativeObjectPropertyAssertion() throws ParseException
	{
		OWLIndividual subj;
		OWLObjectPropertyExpression prop;
		OWLIndividual obj;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(NEGATIVEOBJECTPROPERTYASSERTION);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		prop = ObjectPropertyExpression();
		subj = Individual();
		obj = Individual();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLNegativeObjectPropertyAssertionAxiom(prop, subj, obj, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLIndividualAxiom DataPropertyAssertion() throws ParseException
	{
		OWLIndividual subj;
		OWLDataPropertyExpression prop;
		OWLLiteral obj;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(DATAPROPERTYASSERTION);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		prop = DataPropertyExpression();
		subj = Individual();
		obj = Literal();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLDataPropertyAssertionAxiom(prop, subj, obj, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLIndividualAxiom NegativeDataPropertyAssertion() throws ParseException
	{
		OWLIndividual subj;
		OWLDataPropertyExpression prop;
		OWLLiteral obj;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(NEGATIVEDATAPROPERTYASSERTION);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		prop = DataPropertyExpression();
		subj = Individual();
		obj = Literal();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLNegativeDataPropertyAssertionAxiom(prop, subj, obj, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLNamedIndividual IndividualIRI() throws ParseException
	{
		IRI iri;
		iri = IRI();
		{
			if ("" != null)
				return dataFactory.getOWLNamedIndividual(iri);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLIndividual Individual() throws ParseException
	{
		OWLIndividual ind;
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case FULLIRI:
			case PNAME_LN:
			{
				ind = IndividualIRI();
				break;
			}
			case NODEID:
			{
				ind = AnonymousIndividual();
				break;
			}
			default:
				jj_la1[32] = jj_gen;
				jj_consume_token(-1);
				throw new ParseException();
		}
		{
			if ("" != null)
				return ind;
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLObjectProperty ObjectPropertyIRI() throws ParseException
	{
		IRI iri;
		iri = IRI();
		{
			if ("" != null)
				return dataFactory.getOWLObjectProperty(iri);
		}
		throw new Error("Missing return statement in function");
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//
	// Annotation Stuff
	//
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	final public OWLAxiom AnnotationAxiom() throws ParseException
	{
		OWLAxiom axiom;
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case ANNOTATIONASSERTION:
			{
				axiom = AnnotationAssertion();
				break;
			}
			case ANNOTATIONPROPERTYDOMAIN:
			{
				axiom = AnnotationPropertyDomain();
				break;
			}
			case ANNOTATIONPROPERTYRANGE:
			{
				axiom = AnnotationPropertyRange();
				break;
			}
			case SUBANNOTATIONPROPERTYOF:
			{
				axiom = SubAnnotationPropertyOf();
				break;
			}
			default:
				jj_la1[33] = jj_gen;
				jj_consume_token(-1);
				throw new ParseException();
		}
		{
			if ("" != null)
				return axiom;
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLAnnotation Annotation() throws ParseException
	{
		OWLAnnotationProperty prop;
		OWLAnnotationValue val;
		Set<OWLAnnotation> annos = null;
		OWLAnnotation anno = null;
		jj_consume_token(ANNOTATION);
		annos = new HashSet<>();
		jj_consume_token(OPENPAR);
		label_14: while (true)
		{
			switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
			{
				case ANNOTATION:
				{

					break;
				}
				default:
					jj_la1[34] = jj_gen;
					break label_14;
			}
			anno = Annotation();
			annos.add(anno);
		}
		prop = AnnotationPropertyIRI();
		val = AnnotationValue();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLAnnotation(prop, val, annos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLAnnotationSubject AnnotationSubject() throws ParseException
	{
		OWLAnnotationSubject subj;
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case FULLIRI:
			case PNAME_LN:
			{
				subj = IRI();
				break;
			}
			case NODEID:
			{
				subj = AnonymousIndividual();
				break;
			}
			default:
				jj_la1[35] = jj_gen;
				jj_consume_token(-1);
				throw new ParseException();
		}
		{
			if ("" != null)
				return subj;
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLAnnotationValue AnnotationValue() throws ParseException
	{
		OWLAnnotationValue value;
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case FULLIRI:
			case PNAME_LN:
			{
				value = IRI();
				break;
			}
			case NODEID:
			{
				value = AnonymousIndividual();
				break;
			}
			case STRINGLITERAL:
			{
				value = Literal();
				break;
			}
			default:
				jj_la1[36] = jj_gen;
				jj_consume_token(-1);
				throw new ParseException();
		}
		{
			if ("" != null)
				return value;
		}
		throw new Error("Missing return statement in function");
	}

	final public Set<OWLAnnotation> AxiomAnnotationSet() throws ParseException
	{
		Set<OWLAnnotation> annos = null;
		OWLAnnotation anno;
		label_15: while (true)
		{
			switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
			{
				case ANNOTATION:
				{

					break;
				}
				default:
					jj_la1[37] = jj_gen;
					break label_15;
			}
			anno = Annotation();
			if (annos == null)
				annos = new HashSet<>();
			annos.add(anno);
		}
		if (annos == null)
			annos = Collections.emptySet();
		{
			if ("" != null)
				return annos;
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLImportsDeclaration ImportsDeclaration() throws ParseException
	{
		IRI iri;
		jj_consume_token(IMPORT);
		jj_consume_token(OPENPAR);
		iri = IRI();
		jj_consume_token(CLOSEPAR);
		final OWLImportsDeclaration importsDeclaration = dataFactory.getOWLImportsDeclaration(iri);
		{
			if ("" != null)
				return importsDeclaration;
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLAnnotationAssertionAxiom AnnotationAssertion() throws ParseException
	{
		OWLAnnotationProperty prop;
		OWLAnnotationSubject subj;
		OWLAnnotationValue val;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(ANNOTATIONASSERTION);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		prop = AnnotationPropertyIRI();
		subj = AnnotationSubject();
		val = AnnotationValue();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLAnnotationAssertionAxiom(prop, subj, val, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLSubAnnotationPropertyOfAxiom SubAnnotationPropertyOf() throws ParseException
	{
		OWLAnnotationProperty subProp;
		OWLAnnotationProperty superProperty;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(SUBANNOTATIONPROPERTYOF);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		subProp = AnnotationPropertyIRI();
		superProperty = AnnotationPropertyIRI();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLSubAnnotationPropertyOfAxiom(subProp, superProperty, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLAnnotationPropertyDomainAxiom AnnotationPropertyDomain() throws ParseException
	{
		IRI domain;
		OWLAnnotationProperty prop;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(ANNOTATIONPROPERTYDOMAIN);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		prop = AnnotationPropertyIRI();
		domain = IRI();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLAnnotationPropertyDomainAxiom(prop, domain, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLAnnotationPropertyRangeAxiom AnnotationPropertyRange() throws ParseException
	{
		IRI range;
		OWLAnnotationProperty prop;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(ANNOTATIONPROPERTYRANGE);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		prop = AnnotationPropertyIRI();
		range = IRI();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLAnnotationPropertyRangeAxiom(prop, range, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLHasKeyAxiom HasKey() throws ParseException
	{
		OWLClassExpression ce;
		OWLPropertyExpression prop;
		final Set<OWLPropertyExpression> props = new HashSet<>();
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(HASKEY);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		ce = ClassExpression();
		jj_consume_token(OPENPAR);
		label_16: while (true)
		{
			switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
			{
				case OBJECTINVERSEOF:
				case FULLIRI:
				case PNAME_LN:
				{

					break;
				}
				default:
					jj_la1[38] = jj_gen;
					break label_16;
			}
			prop = ObjectPropertyExpression();
			props.add(prop);
		}
		jj_consume_token(CLOSEPAR);
		jj_consume_token(OPENPAR);
		label_17: while (true)
		{
			switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
			{
				case FULLIRI:
				case PNAME_LN:
				{

					break;
				}
				default:
					jj_la1[39] = jj_gen;
					break label_17;
			}
			prop = DataPropertyExpression();
			props.add(prop);
		}
		jj_consume_token(CLOSEPAR);
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getOWLHasKeyAxiom(ce, props, axiomAnnos);
		}
		throw new Error("Missing return statement in function");
	}

	final public OWLAxiom Declaration() throws ParseException
	{
		OWLEntity entity = null;
		final IRI iri = null;
		final OWLLiteral con = null;
		Set<OWLAnnotation> axiomAnnos;
		jj_consume_token(DECLARATION);
		jj_consume_token(OPENPAR);
		axiomAnnos = AxiomAnnotationSet();
		entity = Entity();
		jj_consume_token(CLOSEPAR);
		if (ignoreAnnotationsAndDeclarations)
		{
			if ("" != null)
				return null;
		}
		else
			if ("" != null)
				return dataFactory.getOWLDeclarationAxiom(entity, axiomAnnos);
		throw new Error("Missing return statement in function");
	}

	final public OWLEntity Entity() throws ParseException
	{
		OWLEntity entity;
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case CLASS:
			{
				entity = Class();
				break;
			}
			case OBJECTPROP:
			{
				entity = ObjectProperty();
				break;
			}
			case DATAPROP:
			{
				entity = DataProperty();
				break;
			}
			case NAMEDINDIVIDUAL:
			{
				entity = NamedIndividual();
				break;
			}
			case DATATYPE:
			{
				entity = Datatype();
				break;
			}
			case ANNOTATIONPROPERTY:
			{
				entity = AnnotationProperty();
				break;
			}
			default:
				jj_la1[40] = jj_gen;
				jj_consume_token(-1);
				throw new ParseException();
		}
		{
			if ("" != null)
				return entity;
		}
		throw new Error("Missing return statement in function");
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//
	// Data Stuff
	//
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	final public OWLLiteral Literal() throws ParseException
	{
		boolean plain = true;
		String literal;
		OWLDatatype datatype = null;
		String lang = "";
		literal = QuotedString();
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case LANGIDENTIFIER:
			case DATATYPEIDENTIFIER:
			{
				switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
				{
					case DATATYPEIDENTIFIER:
					{
						jj_consume_token(DATATYPEIDENTIFIER);
						plain = false;
						datatype = DatatypeIRI();
						break;
					}
					case LANGIDENTIFIER:
					{
						jj_consume_token(LANGIDENTIFIER);
						lang = LangTag();
						break;
					}
					default:
						jj_la1[41] = jj_gen;
						jj_consume_token(-1);
						throw new ParseException();
				}
				break;
			}
			default:
				jj_la1[42] = jj_gen;;
		}
		if (plain)
		{
			if ("" != null)
				return dataFactory.getOWLLiteral(literal, lang);
		}
		else
		{
			// a float value in this syntax has an extra 'f' or 'F' character that must be removed to make a valid OWL literal
			if (datatype.isFloat() && (literal.endsWith("f") || literal.endsWith("F")) && !(literal.endsWith("inf") || literal.endsWith("INF")))
				literal = literal.substring(0, literal.length() - 1);
			{
				if ("" != null)
					return dataFactory.getOWLLiteral(literal, datatype);
			}
		}
		throw new Error("Missing return statement in function");
	}

	final public String QuotedString() throws ParseException
	{
		Token t;
		t = jj_consume_token(STRINGLITERAL);
		final String raw = t.image.substring(1, t.image.length() - 1);
		{
			if ("" != null)
				return EscapeUtils.unescapeString(raw);
		}
		throw new Error("Missing return statement in function");
	}

	final public String LangTag() throws ParseException
	{
		String lang = "";
		Token t;
		t = jj_consume_token(PN_LOCAL);
		lang += t.image;
		{
			if ("" != null)
				return lang;
		}
		throw new Error("Missing return statement in function");
	}

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//
	// Rules
	//
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	final public SWRLRule DLSafeRule() throws ParseException
	{
		Set<OWLAnnotation> annos;
		SWRLAtom atom;
		Set<SWRLAtom> body;
		Set<SWRLAtom> head;
		jj_consume_token(DLSAFERULE);
		jj_consume_token(OPENPAR);
		annos = AxiomAnnotationSet();
		jj_consume_token(BODY);
		body = new LinkedHashSet<>();
		jj_consume_token(OPENPAR);
		label_18: while (true)
		{
			switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
			{
				case CLASSATOM:
				case DATARANGEATOM:
				case OBJECTPROPERTYATOM:
				case DATAPROPERTYATOM:
				case BUILTINATOM:
				case SAMEINDIVIDUALATOM:
				case DIFFERENTINDIVIDUALSATOM:
				{

					break;
				}
				default:
					jj_la1[43] = jj_gen;
					break label_18;
			}
			atom = Atom();
			body.add(atom);
		}
		jj_consume_token(CLOSEPAR);
		jj_consume_token(HEAD);
		head = new LinkedHashSet<>();
		jj_consume_token(OPENPAR);
		label_19: while (true)
		{
			switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
			{
				case CLASSATOM:
				case DATARANGEATOM:
				case OBJECTPROPERTYATOM:
				case DATAPROPERTYATOM:
				case BUILTINATOM:
				case SAMEINDIVIDUALATOM:
				case DIFFERENTINDIVIDUALSATOM:
				{

					break;
				}
				default:
					jj_la1[44] = jj_gen;
					break label_19;
			}
			atom = Atom();
			head.add(atom);
		}
		jj_consume_token(CLOSEPAR);
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getSWRLRule(body, head, annos);
		}
		throw new Error("Missing return statement in function");
	}

	final public SWRLAtom Atom() throws ParseException
	{
		SWRLAtom atom;
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case CLASSATOM:
			{
				atom = ClassAtom();
				break;
			}
			case DATARANGEATOM:
			{
				atom = DataRangeAtom();
				break;
			}
			case OBJECTPROPERTYATOM:
			{
				atom = ObjectPropertyAtom();
				break;
			}
			case DATAPROPERTYATOM:
			{
				atom = DataPropertyAtom();
				break;
			}
			case BUILTINATOM:
			{
				atom = BuiltInAtom();
				break;
			}
			case SAMEINDIVIDUALATOM:
			{
				atom = SameIndividualAtom();
				break;
			}
			case DIFFERENTINDIVIDUALSATOM:
			{
				atom = DifferentIndividualsAtom();
				break;
			}
			default:
				jj_la1[45] = jj_gen;
				jj_consume_token(-1);
				throw new ParseException();
		}
		{
			if ("" != null)
				return atom;
		}
		throw new Error("Missing return statement in function");
	}

	final public SWRLClassAtom ClassAtom() throws ParseException
	{
		OWLClassExpression ce;
		SWRLIArgument arg0;
		jj_consume_token(CLASSATOM);
		jj_consume_token(OPENPAR);
		ce = ClassExpression();
		arg0 = IArg();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getSWRLClassAtom(ce, arg0);
		}
		throw new Error("Missing return statement in function");
	}

	final public SWRLDataRangeAtom DataRangeAtom() throws ParseException
	{
		OWLDataRange rng;
		SWRLDArgument arg0;
		jj_consume_token(DATARANGEATOM);
		jj_consume_token(OPENPAR);
		rng = DataRange();
		arg0 = DArg();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getSWRLDataRangeAtom(rng, arg0);
		}
		throw new Error("Missing return statement in function");
	}

	final public SWRLObjectPropertyAtom ObjectPropertyAtom() throws ParseException
	{
		OWLObjectPropertyExpression prop;
		SWRLIArgument arg0;
		SWRLIArgument arg1;
		jj_consume_token(OBJECTPROPERTYATOM);
		jj_consume_token(OPENPAR);
		prop = ObjectPropertyExpression();
		arg0 = IArg();
		arg1 = IArg();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getSWRLObjectPropertyAtom(prop, arg0, arg1);
		}
		throw new Error("Missing return statement in function");
	}

	final public SWRLDataPropertyAtom DataPropertyAtom() throws ParseException
	{
		OWLDataProperty prop;
		SWRLIArgument arg0;
		SWRLDArgument arg1;
		jj_consume_token(DATAPROPERTYATOM);
		jj_consume_token(OPENPAR);
		prop = DataPropertyIRI();
		arg0 = IArg();
		arg1 = DArg();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getSWRLDataPropertyAtom(prop, arg0, arg1);
		}
		throw new Error("Missing return statement in function");
	}

	final public SWRLBuiltInAtom BuiltInAtom() throws ParseException
	{
		IRI iri;
		List<SWRLDArgument> args;
		SWRLDArgument arg;
		jj_consume_token(BUILTINATOM);
		jj_consume_token(OPENPAR);
		args = new ArrayList<>();
		iri = IRI();
		arg = DArg();
		args.add(arg);
		label_20: while (true)
		{
			switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
			{
				case STRINGLITERAL:
				case VARIABLE:
				{

					break;
				}
				default:
					jj_la1[46] = jj_gen;
					break label_20;
			}
			arg = DArg();
			args.add(arg);
		}
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getSWRLBuiltInAtom(iri, args);
		}
		throw new Error("Missing return statement in function");
	}

	final public SWRLSameIndividualAtom SameIndividualAtom() throws ParseException
	{
		SWRLIArgument arg0;
		SWRLIArgument arg1;
		jj_consume_token(SAMEINDIVIDUALATOM);
		jj_consume_token(OPENPAR);
		arg0 = IArg();
		arg1 = IArg();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getSWRLSameIndividualAtom(arg0, arg1);
		}
		throw new Error("Missing return statement in function");
	}

	final public SWRLDifferentIndividualsAtom DifferentIndividualsAtom() throws ParseException
	{
		SWRLIArgument arg0;
		SWRLIArgument arg1;
		jj_consume_token(DIFFERENTINDIVIDUALSATOM);
		jj_consume_token(OPENPAR);
		arg0 = IArg();
		arg1 = IArg();
		jj_consume_token(CLOSEPAR);
		{
			if ("" != null)
				return dataFactory.getSWRLDifferentIndividualsAtom(arg0, arg1);
		}
		throw new Error("Missing return statement in function");
	}

	final public SWRLIArgument IArg() throws ParseException
	{
		OWLNamedIndividual ind;
		final SWRLIArgument arg;
		IRI iri;
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case VARIABLE:
			{
				jj_consume_token(VARIABLE);
				jj_consume_token(OPENPAR);
				iri = IRI();
				jj_consume_token(CLOSEPAR);
				{
					if ("" != null)
						return dataFactory.getSWRLVariable(iri);
				}
				break;
			}
			case FULLIRI:
			case PNAME_LN:
			{
				ind = IndividualIRI();
				{
					if ("" != null)
						return dataFactory.getSWRLIndividualArgument(ind);
				}
				break;
			}
			default:
				jj_la1[47] = jj_gen;
				jj_consume_token(-1);
				throw new ParseException();
		}
		throw new Error("Missing return statement in function");
	}

	final public SWRLDArgument DArg() throws ParseException
	{
		OWLLiteral literal;
		IRI iri;
		switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk)
		{
			case VARIABLE:
			{
				jj_consume_token(VARIABLE);
				jj_consume_token(OPENPAR);
				iri = IRI();
				jj_consume_token(CLOSEPAR);
				{
					if ("" != null)
						return dataFactory.getSWRLVariable(iri);
				}
				break;
			}
			case STRINGLITERAL:
			{
				literal = Literal();
				{
					if ("" != null)
						return dataFactory.getSWRLLiteralArgument(literal);
				}
				break;
			}
			default:
				jj_la1[48] = jj_gen;
				jj_consume_token(-1);
				throw new ParseException();
		}
		throw new Error("Missing return statement in function");
	}

	/** Generated Token Manager. */
	public OWLFunctionalSyntaxParserTokenManager token_source;
	SimpleCharStream jj_input_stream;
	/** Current token. */
	public Token token;
	/** Next token. */
	public Token jj_nt;
	private int jj_ntk;
	private int jj_gen;
	final private int[] jj_la1 = new int[49];
	static private int[] jj_la1_0;
	static private int[] jj_la1_1;
	static private int[] jj_la1_2;
	static private int[] jj_la1_3;
	static private int[] jj_la1_4;
	static
	{
		jj_la1_init_0();
		jj_la1_init_1();
		jj_la1_init_2();
		jj_la1_init_3();
		jj_la1_init_4();
	}

	private static void jj_la1_init_0()
	{
		jj_la1_0 = new int[] { 0x0, 0x0, 0x0, 0x1010000, 0x1010000, 0xfce40000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x800, 0x0, 0x0, 0x0, 0xfce40000, 0xe40000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3c000000, 0x1000000, 0x0, 0x800, 0x1000000, 0x0, 0x0, 0x2000000, 0x180000, 0x180000, 0x0, 0x0, 0x0, 0x800, 0x0, 0x800, };
	}

	private static void jj_la1_init_1()
	{
		jj_la1_1 = new int[] { 0x0, 0x0, 0x0, 0x0, 0x0, 0x12000, 0x0, 0x7ffe0e00, 0x7ffe0e00, 0x0, 0x7ffe0e00, 0x7ffe0e00, 0x7ffe0e00, 0xc1c0, 0xc1c0, 0xc1c0, 0x1000, 0xc1c0, 0x0, 0xc1c0, 0xc1c0, 0x0, 0x12000, 0x0, 0x2000, 0x1000, 0x80001000, 0x1000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1000, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, };
	}

	private static void jj_la1_init_2()
	{
		jj_la1_2 = new int[] { 0x2000000, 0x0, 0x0, 0x0, 0x0, 0x1ffffff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1ffffff, 0x0, 0xfff, 0x0, 0x0, 0x0, 0x3f000, 0x0, 0x1fc0000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, };
	}

	private static void jj_la1_init_3()
	{
		jj_la1_3 = new int[] { 0x0, 0x9000000, 0x9000000, 0x0, 0x0, 0x10, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x0, 0x9000000, 0x9000000, 0x9000000, 0x10, 0x0, 0x0, 0x9000000, 0x9000000, 0x9000000, 0x0, 0x9000000, 0x0, 0x9000000, 0x9000000, 0x0, 0x0, 0x9000000, 0x9000000, 0x0, 0x9000000, 0x9000000, 0x0, 0x0, 0x0, 0x3f80, 0x3f80, 0x3f80, 0x4000, 0x9004000, 0x4000, };
	}

	private static void jj_la1_init_4()
	{
		jj_la1_4 = new int[] { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x0, 0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, };
	}

	/** Constructor with InputStream. */
	public OWLFunctionalSyntaxParser(final java.io.InputStream stream)
	{
		this(stream, null);
	}

	/** Constructor with InputStream and supplied encoding */
	public OWLFunctionalSyntaxParser(final java.io.InputStream stream, final String encoding)
	{
		try
		{
			jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
		}
		catch (final java.io.UnsupportedEncodingException e)
		{
			throw new OpenError(e);
		}
		token_source = new OWLFunctionalSyntaxParserTokenManager(jj_input_stream);
		token = new Token();
		jj_ntk = -1;
		jj_gen = 0;
		for (int i = 0; i < 49; i++)
			jj_la1[i] = -1;
	}

	/** Reinitialise. */
	public void ReInit(final java.io.InputStream stream)
	{
		ReInit(stream, null);
	}

	/** Reinitialise. */
	public void ReInit(final java.io.InputStream stream, final String encoding)
	{
		try
		{
			jj_input_stream.ReInit(stream, encoding, 1, 1);
		}
		catch (final java.io.UnsupportedEncodingException e)
		{
			throw new OpenError(e);
		}
		token_source.ReInit(jj_input_stream);
		token = new Token();
		jj_ntk = -1;
		jj_gen = 0;
		for (int i = 0; i < 49; i++)
			jj_la1[i] = -1;
	}

	/** Constructor. */
	public OWLFunctionalSyntaxParser(final java.io.Reader stream)
	{
		jj_input_stream = new SimpleCharStream(stream, 1, 1);
		token_source = new OWLFunctionalSyntaxParserTokenManager(jj_input_stream);
		token = new Token();
		jj_ntk = -1;
		jj_gen = 0;
		for (int i = 0; i < 49; i++)
			jj_la1[i] = -1;
	}

	/** Reinitialise. */
	public void ReInit(final java.io.Reader stream)
	{
		if (jj_input_stream == null)
			jj_input_stream = new SimpleCharStream(stream, 1, 1);
		else
			jj_input_stream.ReInit(stream, 1, 1);
		if (token_source == null)
			token_source = new OWLFunctionalSyntaxParserTokenManager(jj_input_stream);

		token_source.ReInit(jj_input_stream);
		token = new Token();
		jj_ntk = -1;
		jj_gen = 0;
		for (int i = 0; i < 49; i++)
			jj_la1[i] = -1;
	}

	/** Constructor with generated Token Manager. */
	public OWLFunctionalSyntaxParser(final OWLFunctionalSyntaxParserTokenManager tm)
	{
		token_source = tm;
		token = new Token();
		jj_ntk = -1;
		jj_gen = 0;
		for (int i = 0; i < 49; i++)
			jj_la1[i] = -1;
	}

	/** Reinitialise. */
	public void ReInit(final OWLFunctionalSyntaxParserTokenManager tm)
	{
		token_source = tm;
		token = new Token();
		jj_ntk = -1;
		jj_gen = 0;
		for (int i = 0; i < 49; i++)
			jj_la1[i] = -1;
	}

	private Token jj_consume_token(final int kind) throws ParseException
	{
		Token oldToken;
		if ((oldToken = token).next != null)
			token = token.next;
		else
			token = token.next = token_source.getNextToken();
		jj_ntk = -1;
		if (token.kind == kind)
		{
			jj_gen++;
			return token;
		}
		token = oldToken;
		jj_kind = kind;
		throw generateParseException();
	}

	/** Get the next Token. */
	final public Token getNextToken()
	{
		if (token.next != null)
			token = token.next;
		else
			token = token.next = token_source.getNextToken();
		jj_ntk = -1;
		jj_gen++;
		return token;
	}

	/** Get the specific Token. */
	final public Token getToken(final int index)
	{
		Token t = token;
		for (int i = 0; i < index; i++)
			if (t.next != null)
				t = t.next;
			else
				t = t.next = token_source.getNextToken();
		return t;
	}

	private int jj_ntk_f()
	{
		if ((jj_nt = token.next) == null)
			return jj_ntk = (token.next = token_source.getNextToken()).kind;
		else
			return jj_ntk = jj_nt.kind;
	}

	private final java.util.List<int[]> jj_expentries = new java.util.ArrayList<>();
	private int[] jj_expentry;
	private int jj_kind = -1;

	/** Generate ParseException. */
	public ParseException generateParseException()
	{
		jj_expentries.clear();
		final boolean[] la1tokens = new boolean[130];
		if (jj_kind >= 0)
		{
			la1tokens[jj_kind] = true;
			jj_kind = -1;
		}
		for (int i = 0; i < 49; i++)
			if (jj_la1[i] == jj_gen)
				for (int j = 0; j < 32; j++)
				{
					if ((jj_la1_0[i] & 1 << j) != 0)
						la1tokens[j] = true;
					if ((jj_la1_1[i] & 1 << j) != 0)
						la1tokens[32 + j] = true;
					if ((jj_la1_2[i] & 1 << j) != 0)
						la1tokens[64 + j] = true;
					if ((jj_la1_3[i] & 1 << j) != 0)
						la1tokens[96 + j] = true;
					if ((jj_la1_4[i] & 1 << j) != 0)
						la1tokens[128 + j] = true;
				}
		for (int i = 0; i < 130; i++)
			if (la1tokens[i])
			{
				jj_expentry = new int[1];
				jj_expentry[0] = i;
				jj_expentries.add(jj_expentry);
			}
		final int[][] exptokseq = new int[jj_expentries.size()][];
		for (int i = 0; i < jj_expentries.size(); i++)
			exptokseq[i] = jj_expentries.get(i);
		return new ParseException(token, exptokseq, tokenImage);
	}

	/** Enable tracing. */
	final public void enable_tracing()
	{
	}

	/** Disable tracing. */
	final public void disable_tracing()
	{
	}

}
