// Copyright (c) 2006 - 2008, Clark & Parsia, LLC. <http://www.clarkparsia.com>
// This source code is available under the terms of the Affero General Public License v3.
//
// Please see LICENSE.txt for full license terms, including the availability of proprietary exceptions.
// Questions, comments, or requests for clarification: licensing@clarkparsia.com

package openllet.modularity.test;

import openllet.modularity.AxiomBasedModuleExtractor;
import openllet.modularity.ModuleExtractor;

/**
 * <p>
 * Description: Test modular classification for correctness against unified classification
 * <p>
 * Copyright: Copyright (c) 2007
 * </p>
 * <p>
 * Company: Clark & Parsia, LLC. <http://www.clarkparsia.com>
 * </p>
 *
 * @author Mike Smith
 */
public class AxiomBasedRandomizedIncrementalClassifierTest extends RandomizedIncrementalClassifierTest
{
	public AxiomBasedRandomizedIncrementalClassifierTest()
	{
		super("test/data/modularity/");
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ModuleExtractor createModuleExtractor()
	{
		return new AxiomBasedModuleExtractor();
	}
}
